require( "quest/m3_landing13/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m3_signatures" then
			actor:JumpToNamedPoint("signatures");
			actor:FaceNow(DIR.E);
		elseif lastScene == "m3_lobby"  or lastScene == "m3_landing13" then
			actor:JumpToNamedPoint("elevator");
			sfx:PlaySFX("audio/sfx/big_elevator");
			scene.ELEVATOR:PlayAnim("Close");
			actor:FaceNow(DIR.S);
		else -- lastScene == m2_sunnyside
			actor:JumpToNamedPoint("maze");
			actor:FaceNow(DIR.W);
		end
		
		actor:WalkTo("flo");
		wait_walkto();
		
		actor:Face(DIR.S);
		
		if ( game:Get( "got_permit_signed" ) == 1 and game:Get( "goto_cube" ) ~= 1 ) then
			game:Set( "goto_cube", 1 );
			run_super_conversation(actor, "quip_landing50_need_stamp");
		end
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	on_arrive = function(flo, button)
		if ( game:Get( "got_permit_signed" ) == 1 ) then
			flo:StartProc(flo_need_permit_stamped);				
		else
			flo:StartProc(flo_need_permit_signed);			
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function flo_need_permit_signed(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing50_flo_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function flo_need_permit_stamped(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing50_flo_B");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function gotomaze(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if ( game:Get( "got_permit_signed" ) == 1 ) then
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("maze");
		wait_walkto();
		goto_scene(flo, "m3_maze3");
	else
		run_super_conversation(flo, "quip_landing50_maze");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

maze_spec = 
{
	name = "MAZE";
	halo = "maze";
	cursor = "cursor_arrow_e";
	goto_fn = gotomaze;
};

function use_keycard_on_elevator(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	if ( game:Get( "got_permit_signed" ) ~= 1 ) then
		run_super_conversation(flo, "quip_landing50_elevator_B");
	elseif ( game:Get( "got_permit_stamped" ) ~= 1 ) then
		run_super_conversation(flo, "quip_landing50_elevator_C" );
	end
	
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Down");
	flo:WalkTo("elevator");
	wait_walkto();
	goto_scene(flo, "m3_landing13");
end

function use_bluekey_on_elevator(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	if ( game:Get( "got_permit_signed" ) ~= 1 ) then
		run_super_conversation(flo, "quip_landing50_elevator_B");
	elseif ( game:Get( "got_permit_stamped" ) ~= 1 ) then
		run_super_conversation(flo, "quip_landing50_elevator_C" );
	end
	
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Down");
	flo:WalkTo("elevator");
	wait_walkto();
	goto_scene(flo, "m3_lobby");
end

elevator_spec = 
{
	name = "ELEVATOR";
	halo = "elevator";
	gfx = { anim = "anim/m3_lobby/elevator_door" };
	
	command = function(actor)
		actor:SetDepthValue(2);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Closed");
	end;
	
	on_arrive = function(flo, button)				
		flo:StartProc(use_keycard);
	end;	
	on_use_inv = function(item, flo, elevator_blue)	
		if ( item == "keycard" ) then
			flo:StartProc(use_keycard_on_elevator);
		elseif ( item == "bluekey" ) then		
			flo:StartProc(use_bluekey_on_elevator);
		end
	end;
}

elevator_button_spec = 
{
	name = "ELEVATOR_BUTTON";
	gfx = { anim = "anim/m3_lobby/elevator_button" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Off");
	end;
}

function gotosignatures(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if ( game:Get( "got_permit_signed" ) == 1 ) then
		run_super_conversation(flo, "quip_lobby_flo_C");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("signatures");
		wait_walkto();
		goto_scene(flo, "m3_signatures");
	end
end

signatures_spec = 
{
	name = "SIGNATURE_DOOR";
	halo = "signatures";
	cursor = "cursor_arrow_w";
	goto_fn = gotosignatures;
};

function use_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing50_elevator_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

number_sign_spec = 
{
	name = "NUMBER_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/broadway.mvec",
			color = { a = 1, r = 0.9, g = 0.96, b = 0.98 },
			outline_size = 0,
			lineheight = 50,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_number_sign");
		actor:StopWalking();
		actor:SetPolygon({x=516,y=190}, {x=620,y=190}, {x=507,y=229}, {x=609,y=226});
		actor:TextToImage(40, 10);
	end;
}

signatures_sign_spec = 
{
	name = "SIGNATURES_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 0, g = 0., b = 0 },
			outline_size = 0,
			lineheight = 50,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_signatures_sign");
		actor:StopWalking();
		actor:SetPolygon({x=21,y=156}, {x=117,y=186}, {x=21,y=181}, {x=118,y=211});
		actor:TextToImage(20, 00);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(360, 490, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(maze_spec);
		spawn_nav_arrow(signatures_spec);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		{ "plant_left", DEPTH.DEPTH_FRONTMOST  },
		{ "plant_right", DEPTH.DEPTH_FRONTMOST  },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		elevator_spec,
		elevator_button_spec,
		flo_spec, -- the main actor
		
		scene_setup,
		number_sign_spec,
		signatures_sign_spec,
	};
};
